
#!/bin/bash

# Script para parar o Gerenciador de Currículos

echo "🛑 Parando Gerenciador de Currículos..."

# Parar containers
docker stop gerenciador_curriculos_app 2>/dev/null || true
docker stop gerenciador_curriculos_mysql 2>/dev/null || true
docker stop gerenciador_curriculos_phpmyadmin 2>/dev/null || true

# Remover containers
docker rm gerenciador_curriculos_app 2>/dev/null || true
docker rm gerenciador_curriculos_mysql 2>/dev/null || true
docker rm gerenciador_curriculos_phpmyadmin 2>/dev/null || true

echo "✅ Containers parados e removidos!"
echo ""
echo "💾 Dados preservados nos volumes:"
echo "   - mysql_data"
echo "   - app_sessions"
echo "   - ./public/uploads"
echo "   - ./logs"
echo ""
echo "🗑️ Para remover todos os dados:"
echo "   docker volume rm mysql_data app_sessions"
echo "   docker network rm curriculos_network"
