
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Sistema de gerenciamento de currículos">
    <title><?= isset($title) ? sanitize($title) . ' - ' . APP_NAME : APP_NAME ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <!-- Custom CSS -->
    <style>
        :root {
            --primary-color: #3498db;
            --secondary-color: #2c3e50;
            --success-color: #27ae60;
            --warning-color: #f39c12;
            --danger-color: #e74c3c;
            --info-color: #17a2b8;
            --light-bg: #f8f9fa;
            --dark-bg: #343a40;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f6fa;
            color: #333;
        }
        
        .navbar-brand {
            font-weight: 700;
            color: var(--primary-color) !important;
        }
        
        .navbar {
            box-shadow: 0 2px 4px rgba(0,0,0,.1);
            background: white !important;
        }
        
        .sidebar {
            background: linear-gradient(135deg, var(--secondary-color), #34495e);
            min-height: calc(100vh - 56px);
            color: white;
        }
        
        .sidebar .nav-link {
            color: rgba(255,255,255,0.8);
            padding: 12px 20px;
            border-radius: 8px;
            margin: 2px 10px;
            transition: all 0.3s ease;
        }
        
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            background: rgba(255,255,255,0.1);
            color: white;
            transform: translateX(5px);
        }
        
        .sidebar .nav-link i {
            width: 20px;
            text-align: center;
            margin-right: 10px;
        }
        
        .main-content {
            padding: 20px;
            min-height: calc(100vh - 56px);
        }
        
        .card {
            border: none;
            box-shadow: 0 2px 10px rgba(0,0,0,.1);
            border-radius: 15px;
            transition: transform 0.3s ease;
        }
        
        .card:hover {
            transform: translateY(-5px);
        }
        
        .card-header {
            background: linear-gradient(135deg, var(--primary-color), #5dade2);
            color: white;
            border-radius: 15px 15px 0 0 !important;
            border: none;
        }
        
        .btn {
            border-radius: 8px;
            padding: 8px 20px;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0,0,0,.2);
        }
        
        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color), #5dade2);
            border: none;
        }
        
        .btn-success {
            background: linear-gradient(135deg, var(--success-color), #58d68d);
            border: none;
        }
        
        .btn-warning {
            background: linear-gradient(135deg, var(--warning-color), #f7c52d);
            border: none;
        }
        
        .btn-danger {
            background: linear-gradient(135deg, var(--danger-color), #ec7063);
            border: none;
        }
        
        .alert {
            border: none;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,.1);
        }
        
        .table {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,.1);
        }
        
        .table thead th {
            background: var(--light-bg);
            border: none;
            font-weight: 600;
            color: var(--secondary-color);
        }
        
        .form-control,
        .form-select {
            border-radius: 8px;
            border: 1px solid #e0e6ed;
            padding: 10px 15px;
            transition: all 0.3s ease;
        }
        
        .form-control:focus,
        .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(52, 152, 219, 0.25);
        }
        
        .badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.85em;
        }
        
        .breadcrumb {
            background: none;
            padding: 0;
            margin-bottom: 20px;
        }
        
        .breadcrumb-item a {
            color: var(--primary-color);
            text-decoration: none;
        }
        
        .stats-card {
            background: linear-gradient(135deg, var(--primary-color), #5dade2);
            color: white;
            border-radius: 15px;
            padding: 20px;
            text-align: center;
            transition: transform 0.3s ease;
        }
        
        .stats-card:hover {
            transform: scale(1.05);
        }
        
        .stats-card i {
            font-size: 2.5rem;
            margin-bottom: 10px;
        }
        
        .stats-card h3 {
            font-size: 2rem;
            font-weight: 700;
            margin: 0;
        }
        
        .stats-card p {
            margin: 0;
            opacity: 0.9;
        }
        
        .loading {
            text-align: center;
            padding: 40px;
        }
        
        .spinner-border {
            color: var(--primary-color);
        }
        
        @media (max-width: 768px) {
            .sidebar {
                position: fixed;
                top: 56px;
                left: -250px;
                width: 250px;
                z-index: 1000;
                transition: left 0.3s ease;
            }
            
            .sidebar.show {
                left: 0;
            }
            
            .main-content {
                margin-left: 0;
            }
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-light fixed-top">
        <div class="container-fluid">
            <button class="btn btn-outline-primary me-3 d-lg-none" type="button" data-bs-toggle="collapse" data-bs-target="#sidebar">
                <i class="bi bi-list"></i>
            </button>
            
            <a class="navbar-brand" href="/dashboard">
                <i class="fas fa-file-alt me-2"></i>
                <?= APP_NAME ?>
            </a>
            
            <div class="d-flex align-items-center">
                <!-- Notificações -->
                <div class="dropdown me-3">
                    <button class="btn btn-outline-secondary" type="button" data-bs-toggle="dropdown">
                        <i class="bi bi-bell"></i>
                        <span class="badge bg-danger">3</span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><h6 class="dropdown-header">Notificações</h6></li>
                        <li><a class="dropdown-item" href="#"><i class="bi bi-info-circle me-2"></i>Novo currículo adicionado</a></li>
                        <li><a class="dropdown-item" href="#"><i class="bi bi-check-circle me-2"></i>Candidato aprovado</a></li>
                        <li><a class="dropdown-item" href="#"><i class="bi bi-exclamation-triangle me-2"></i>Relatório disponível</a></li>
                    </ul>
                </div>
                
                <!-- Usuário -->
                <div class="dropdown">
                    <button class="btn btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                        <i class="bi bi-person-circle me-2"></i>
                        <?= $_SESSION['user_name'] ?? 'Usuário' ?>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="/profile"><i class="bi bi-person me-2"></i>Meu Perfil</a></li>
                        <li><a class="dropdown-item" href="/dashboard/reports"><i class="bi bi-graph-up me-2"></i>Relatórios</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="/logout"><i class="bi bi-box-arrow-right me-2"></i>Sair</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>
    
    <div class="container-fluid" style="margin-top: 56px;">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-lg-3 col-xl-2 sidebar collapse d-lg-block" id="sidebar">
                <div class="p-3">
                    <ul class="nav nav-pills flex-column">
                        <li class="nav-item">
                            <a class="nav-link <?= (strpos($_SERVER['REQUEST_URI'], '/dashboard') === 0) ? 'active' : '' ?>" href="/dashboard">
                                <i class="bi bi-speedometer2"></i>
                                Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?= (strpos($_SERVER['REQUEST_URI'], '/curriculos') === 0) ? 'active' : '' ?>" href="/curriculos">
                                <i class="bi bi-file-earmark-person"></i>
                                Currículos
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?= (strpos($_SERVER['REQUEST_URI'], '/grupos') === 0) ? 'active' : '' ?>" href="/grupos">
                                <i class="bi bi-collection"></i>
                                Grupos
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?= (strpos($_SERVER['REQUEST_URI'], '/etiquetas') === 0) ? 'active' : '' ?>" href="/etiquetas">
                                <i class="bi bi-tags"></i>
                                Etiquetas
                            </a>
                        </li>
                        
                        <?php if (in_array($_SESSION['user_type'] ?? '', ['admin', 'rh'])): ?>
                        <li class="nav-item">
                            <a class="nav-link <?= (strpos($_SERVER['REQUEST_URI'], '/usuarios') === 0) ? 'active' : '' ?>" href="/usuarios">
                                <i class="bi bi-people"></i>
                                Usuários
                            </a>
                        </li>
                        <?php endif; ?>
                        
                        <li class="nav-item mt-3">
                            <a class="nav-link" href="/dashboard/reports">
                                <i class="bi bi-graph-up"></i>
                                Relatórios
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-lg-9 col-xl-10 main-content">
                <?php if (isset($breadcrumb) && is_array($breadcrumb)): ?>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <?php foreach ($breadcrumb as $key => $value): ?>
                            <?php if (is_numeric($key)): ?>
                                <li class="breadcrumb-item active"><?= sanitize($value) ?></li>
                            <?php else: ?>
                                <li class="breadcrumb-item">
                                    <a href="<?= sanitize($value) ?>"><?= sanitize($key) ?></a>
                                </li>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </ol>
                </nav>
                <?php endif; ?>
                
                <!-- Flash Messages -->
                <?php if (isset($_SESSION['success'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle me-2"></i>
                    <?= $_SESSION['success'] ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php unset($_SESSION['success']); endif; ?>
                
                <?php if (isset($_SESSION['error'])): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    <?= $_SESSION['error'] ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php unset($_SESSION['error']); endif; ?>
                
                <?php if (isset($_SESSION['warning'])): ?>
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    <?= $_SESSION['warning'] ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php unset($_SESSION['warning']); endif; ?>
                
                <?php if (isset($_SESSION['info'])): ?>
                <div class="alert alert-info alert-dismissible fade show" role="alert">
                    <i class="bi bi-info-circle me-2"></i>
                    <?= $_SESSION['info'] ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php unset($_SESSION['info']); endif; ?>
                
                <!-- Page Content -->
                <div class="content">
                    <?php if (isset($content)) echo $content; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    
    <!-- Custom JavaScript -->
    <script>
        // Auto-hide alerts após 5 segundos
        setTimeout(function() {
            $('.alert').fadeOut('slow');
        }, 5000);
        
        // Toggle sidebar no mobile
        document.addEventListener('DOMContentLoaded', function() {
            const sidebarToggle = document.querySelector('[data-bs-target="#sidebar"]');
            const sidebar = document.getElementById('sidebar');
            
            if (sidebarToggle && sidebar) {
                sidebarToggle.addEventListener('click', function() {
                    sidebar.classList.toggle('show');
                });
                
                // Fechar sidebar ao clicar fora (mobile)
                document.addEventListener('click', function(e) {
                    if (window.innerWidth < 768 && 
                        !sidebar.contains(e.target) && 
                        !sidebarToggle.contains(e.target) &&
                        sidebar.classList.contains('show')) {
                        sidebar.classList.remove('show');
                    }
                });
            }
        });
        
        // Confirmação de exclusão
        function confirmDelete(message) {
            return confirm(message || 'Tem certeza que deseja excluir este item?');
        }
        
        // Loading state para formulários
        function showLoading(button) {
            if (button) {
                button.disabled = true;
                const originalText = button.innerHTML;
                button.innerHTML = '<i class="spinner-border spinner-border-sm me-2"></i>Processando...';
                
                setTimeout(function() {
                    button.disabled = false;
                    button.innerHTML = originalText;
                }, 3000);
            }
        }
        
        // Máscaras para campos
        function phoneMask(input) {
            let value = input.value.replace(/\D/g, '');
            if (value.length >= 11) {
                value = value.replace(/(\d{2})(\d{5})(\d{4})/, '($1) $2-$3');
            } else if (value.length >= 7) {
                value = value.replace(/(\d{2})(\d{4})(\d{0,4})/, '($1) $2-$3');
            } else if (value.length >= 3) {
                value = value.replace(/(\d{2})(\d{0,5})/, '($1) $2');
            }
            input.value = value;
        }
        
        function cepMask(input) {
            let value = input.value.replace(/\D/g, '');
            if (value.length >= 5) {
                value = value.replace(/(\d{5})(\d{0,3})/, '$1-$2');
            }
            input.value = value;
        }
        
        // Aplicar máscaras automaticamente
        document.addEventListener('DOMContentLoaded', function() {
            // Máscara de telefone
            const phoneInputs = document.querySelectorAll('input[type="tel"], input[name*="telefone"], input[name*="celular"]');
            phoneInputs.forEach(input => {
                input.addEventListener('input', function() {
                    phoneMask(this);
                });
            });
            
            // Máscara de CEP
            const cepInputs = document.querySelectorAll('input[name="cep"]');
            cepInputs.forEach(input => {
                input.addEventListener('input', function() {
                    cepMask(this);
                });
            });
        });
    </script>
</body>
</html>
