
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Erro interno - <?= APP_NAME ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .error-container {
            text-align: center;
            color: white;
            max-width: 600px;
            padding: 20px;
        }
        
        .error-code {
            font-size: 8rem;
            font-weight: 700;
            line-height: 1;
            text-shadow: 0 4px 20px rgba(0,0,0,0.3);
            animation: pulse 2s infinite;
        }
        
        .error-message {
            font-size: 1.5rem;
            margin-bottom: 30px;
            opacity: 0.9;
        }
        
        .btn {
            border-radius: 50px;
            padding: 12px 30px;
            font-weight: 600;
            text-decoration: none;
            background: rgba(255,255,255,0.2);
            color: white;
            border: 2px solid white;
            transition: all 0.3s ease;
        }
        
        .btn:hover {
            background: white;
            color: #e74c3c;
            transform: translateY(-2px);
        }
        
        @keyframes pulse {
            0% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.05);
            }
            100% {
                transform: scale(1);
            }
        }
    </style>
</head>
<body>
    <div class="error-container">
        <div class="error-code">500</div>
        <h1 class="error-message">Erro interno do servidor</h1>
        <p class="mb-4">Desculpe, algo deu errado. Nossa equipe foi notificada e está trabalhando para resolver o problema.</p>
        
        <div class="d-flex justify-content-center gap-3 flex-wrap">
            <a href="/dashboard" class="btn">
                <i class="bi bi-house me-2"></i>
                Ir para Dashboard
            </a>
            <a href="javascript:history.back()" class="btn">
                <i class="bi bi-arrow-left me-2"></i>
                Tentar Novamente
            </a>
        </div>
    </div>
</body>
</html>
