
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Página não encontrada - <?= APP_NAME ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .error-container {
            text-align: center;
            color: white;
            max-width: 600px;
            padding: 20px;
        }
        
        .error-code {
            font-size: 8rem;
            font-weight: 700;
            line-height: 1;
            text-shadow: 0 4px 20px rgba(0,0,0,0.3);
            animation: bounce 2s infinite;
        }
        
        .error-message {
            font-size: 1.5rem;
            margin-bottom: 30px;
            opacity: 0.9;
        }
        
        .btn {
            border-radius: 50px;
            padding: 12px 30px;
            font-weight: 600;
            text-decoration: none;
            background: rgba(255,255,255,0.2);
            color: white;
            border: 2px solid white;
            transition: all 0.3s ease;
        }
        
        .btn:hover {
            background: white;
            color: #667eea;
            transform: translateY(-2px);
        }
        
        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% {
                transform: translateY(0);
            }
            40% {
                transform: translateY(-30px);
            }
            60% {
                transform: translateY(-15px);
            }
        }
        
        .floating-icons {
            position: absolute;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: -1;
        }
        
        .floating-icons i {
            position: absolute;
            color: rgba(255,255,255,0.1);
            font-size: 2rem;
            animation: float 6s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(180deg); }
        }
    </style>
</head>
<body>
    <div class="floating-icons">
        <i class="bi bi-file-earmark-x" style="top: 10%; left: 10%; animation-delay: 0s;"></i>
        <i class="bi bi-question-circle" style="top: 20%; right: 20%; animation-delay: 1s;"></i>
        <i class="bi bi-exclamation-triangle" style="bottom: 20%; left: 15%; animation-delay: 2s;"></i>
        <i class="bi bi-search" style="bottom: 30%; right: 10%; animation-delay: 3s;"></i>
    </div>
    
    <div class="error-container">
        <div class="error-code">404</div>
        <h1 class="error-message">Oops! Página não encontrada</h1>
        <p class="mb-4">A página que você está procurando pode ter sido removida, renomeada ou está temporariamente indisponível.</p>
        
        <div class="d-flex justify-content-center gap-3 flex-wrap">
            <a href="/dashboard" class="btn">
                <i class="bi bi-house me-2"></i>
                Ir para Dashboard
            </a>
            <a href="javascript:history.back()" class="btn">
                <i class="bi bi-arrow-left me-2"></i>
                Voltar
            </a>
        </div>
    </div>
</body>
</html>
