
<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col">
        <h1 class="display-6 mb-0">
            <i class="bi bi-speedometer2 me-3"></i>
            Dashboard
        </h1>
        <p class="text-muted">Visão geral do sistema de currículos</p>
    </div>
</div>

<!-- Estatísticas -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="stats-card" style="background: linear-gradient(135deg, #3498db, #5dade2);">
            <i class="bi bi-file-earmark-person"></i>
            <h3><?= number_format($curriculumStats['total'] ?? 0) ?></h3>
            <p>Total de Currículos</p>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="stats-card" style="background: linear-gradient(135deg, #27ae60, #58d68d);">
            <i class="bi bi-check-circle"></i>
            <h3><?= number_format($curriculumStats['aprovados'] ?? 0) ?></h3>
            <p>Aprovados</p>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="stats-card" style="background: linear-gradient(135deg, #f39c12, #f7c52d);">
            <i class="bi bi-clock"></i>
            <h3><?= number_format($curriculumStats['novos'] ?? 0) ?></h3>
            <p>Novos</p>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="stats-card" style="background: linear-gradient(135deg, #e74c3c, #ec7063);">
            <i class="bi bi-person-check"></i>
            <h3><?= number_format($curriculumStats['contratados'] ?? 0) ?></h3>
            <p>Contratados</p>
        </div>
    </div>
</div>

<div class="row">
    <!-- Gráficos -->
    <div class="col-lg-8 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="bi bi-graph-up me-2"></i>
                    Currículos por Mês
                </h5>
                <div class="btn-group" role="group">
                    <input type="radio" class="btn-check" name="chartType" id="line" checked>
                    <label class="btn btn-outline-light btn-sm" for="line">Linha</label>
                    
                    <input type="radio" class="btn-check" name="chartType" id="bar">
                    <label class="btn btn-outline-light btn-sm" for="bar">Barras</label>
                </div>
            </div>
            <div class="card-body">
                <canvas id="monthlyChart" height="100"></canvas>
            </div>
        </div>
    </div>
    
    <!-- Status Distribution -->
    <div class="col-lg-4 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="bi bi-pie-chart me-2"></i>
                    Status dos Currículos
                </h5>
            </div>
            <div class="card-body">
                <canvas id="statusChart" height="150"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Últimos Currículos -->
    <div class="col-lg-8 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="bi bi-clock-history me-2"></i>
                    Últimos Currículos Adicionados
                </h5>
                <a href="/curriculos" class="btn btn-sm btn-outline-light">
                    Ver Todos <i class="bi bi-arrow-right"></i>
                </a>
            </div>
            <div class="card-body">
                <?php if (!empty($recentCurriculums)): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>Email</th>
                                <th>Status</th>
                                <th>Data</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recentCurriculums as $cv): ?>
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <?php if ($cv['foto']): ?>
                                        <img src="/files/<?= htmlspecialchars($cv['foto']) ?>" 
                                             class="rounded-circle me-2" width="32" height="32" alt="Foto">
                                        <?php else: ?>
                                        <div class="bg-secondary rounded-circle d-flex align-items-center justify-content-center me-2" 
                                             style="width: 32px; height: 32px; color: white; font-size: 14px;">
                                            <?= strtoupper(substr($cv['nome_completo'], 0, 1)) ?>
                                        </div>
                                        <?php endif; ?>
                                        <strong><?= sanitize($cv['nome_completo']) ?></strong>
                                    </div>
                                </td>
                                <td><?= sanitize($cv['email']) ?></td>
                                <td>
                                    <span class="badge bg-<?php 
                                        echo match($cv['status']) {
                                            'novo' => 'primary',
                                            'triagem' => 'warning',
                                            'aprovado' => 'success',
                                            'rejeitado' => 'danger',
                                            'entrevista' => 'info',
                                            'contratado' => 'dark',
                                            default => 'secondary'
                                        };
                                    ?>">
                                        <?= CURRICULUM_STATUS[$cv['status']] ?? $cv['status'] ?>
                                    </span>
                                </td>
                                <td>
                                    <small class="text-muted">
                                        <?= formatDate($cv['data_criacao'], 'd/m/Y H:i') ?>
                                    </small>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="/curriculos/<?= $cv['id'] ?>" class="btn btn-sm btn-outline-primary" 
                                           title="Visualizar">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        <a href="/curriculos/<?= $cv['id'] ?>/edit" class="btn btn-sm btn-outline-secondary" 
                                           title="Editar">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <div class="text-center py-5">
                    <i class="bi bi-inbox display-1 text-muted"></i>
                    <h5 class="text-muted mt-3">Nenhum currículo encontrado</h5>
                    <p class="text-muted">Comece adicionando o primeiro currículo ao sistema.</p>
                    <a href="/curriculos/create" class="btn btn-primary">
                        <i class="bi bi-plus-circle me-2"></i>
                        Adicionar Currículo
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Quick Actions & Info -->
    <div class="col-lg-4">
        <!-- Quick Actions -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="bi bi-lightning me-2"></i>
                    Ações Rápidas
                </h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="/curriculos/create" class="btn btn-primary">
                        <i class="bi bi-plus-circle me-2"></i>
                        Novo Currículo
                    </a>
                    <a href="/grupos/create" class="btn btn-outline-primary">
                        <i class="bi bi-collection me-2"></i>
                        Novo Grupo
                    </a>
                    <a href="/etiquetas/create" class="btn btn-outline-secondary">
                        <i class="bi bi-tags me-2"></i>
                        Nova Etiqueta
                    </a>
                    <a href="/dashboard/export" class="btn btn-outline-success">
                        <i class="bi bi-download me-2"></i>
                        Exportar Dados
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Groups Summary -->
        <?php if (!empty($groups)): ?>
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="bi bi-collection me-2"></i>
                    Meus Grupos
                </h5>
            </div>
            <div class="card-body">
                <?php foreach (array_slice($groups, 0, 5) as $group): ?>
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <div class="d-flex align-items-center">
                        <div class="rounded" style="width: 12px; height: 12px; background-color: <?= sanitize($group['cor']) ?>; margin-right: 8px;"></div>
                        <span><?= sanitize($group['nome']) ?></span>
                    </div>
                    <span class="badge bg-light text-dark"><?= $group['total_curriculos'] ?></span>
                </div>
                <?php endforeach; ?>
                
                <?php if (count($groups) > 5): ?>
                <div class="text-center mt-3">
                    <a href="/grupos" class="btn btn-sm btn-outline-primary">Ver Todos</a>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- User Stats -->
        <?php if (isset($userStats) && $userStats): ?>
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="bi bi-people me-2"></i>
                    Usuários do Sistema
                </h5>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-6">
                        <h4 class="text-primary"><?= $userStats['total'] ?></h4>
                        <small class="text-muted">Total</small>
                    </div>
                    <div class="col-6">
                        <h4 class="text-success"><?= $userStats['ativos'] ?></h4>
                        <small class="text-muted">Ativos</small>
                    </div>
                </div>
                <hr>
                <div class="small">
                    <div class="d-flex justify-content-between">
                        <span>Administradores:</span>
                        <span><?= $userStats['admins'] ?></span>
                    </div>
                    <div class="d-flex justify-content-between">
                        <span>RH:</span>
                        <span><?= $userStats['rh'] ?></span>
                    </div>
                    <div class="d-flex justify-content-between">
                        <span>Recrutadores:</span>
                        <span><?= $userStats['recrutadores'] ?></span>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Dados dos gráficos
    const monthlyData = <?= json_encode($monthlyData) ?>;
    const statusData = <?= json_encode($statusData) ?>;
    
    // Gráfico mensal
    const monthlyCtx = document.getElementById('monthlyChart').getContext('2d');
    const monthlyChart = new Chart(monthlyCtx, {
        type: 'line',
        data: {
            labels: monthlyData.labels,
            datasets: [{
                label: 'Currículos Adicionados',
                data: monthlyData.data,
                borderColor: '#3498db',
                backgroundColor: 'rgba(52, 152, 219, 0.1)',
                borderWidth: 3,
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            }
        }
    });
    
    // Gráfico de status
    const statusCtx = document.getElementById('statusChart').getContext('2d');
    new Chart(statusCtx, {
        type: 'doughnut',
        data: {
            labels: statusData.labels,
            datasets: [{
                data: statusData.data,
                backgroundColor: [
                    '#3498db', // Novo
                    '#f39c12', // Triagem
                    '#27ae60', // Aprovado
                    '#e74c3c', // Rejeitado
                    '#17a2b8', // Entrevista
                    '#343a40'  // Contratado
                ],
                borderWidth: 0
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true
                    }
                }
            }
        }
    });
    
    // Toggle tipo do gráfico mensal
    document.querySelectorAll('input[name="chartType"]').forEach(radio => {
        radio.addEventListener('change', function() {
            monthlyChart.config.type = this.id;
            monthlyChart.update();
        });
    });
});
</script>

<?php
$content = ob_get_clean();
require VIEWS_PATH . '/layouts/app.php';
?>
