
<?php
$subtitle = 'Crie sua conta para começar';
$footer = '<p class="mb-0">Já tem uma conta? <a href="/login">Faça login aqui</a></p>';

ob_start();
?>

<form method="POST" action="/register" novalidate>
    <input type="hidden" name="csrf_token" value="<?= generateCsrfToken() ?>">
    
    <div class="input-group">
        <span class="input-group-text">
            <i class="bi bi-person"></i>
        </span>
        <input type="text" class="form-control" name="nome" placeholder="Nome completo" required 
               value="<?= sanitize($_SESSION['form_data']['nome'] ?? '') ?>">
    </div>
    
    <div class="input-group">
        <span class="input-group-text">
            <i class="bi bi-envelope"></i>
        </span>
        <input type="email" class="form-control" name="email" placeholder="Seu email" required 
               value="<?= sanitize($_SESSION['form_data']['email'] ?? '') ?>">
    </div>
    
    <div class="input-group">
        <span class="input-group-text">
            <i class="bi bi-telephone"></i>
        </span>
        <input type="tel" class="form-control" name="telefone" placeholder="Telefone (opcional)" 
               value="<?= sanitize($_SESSION['form_data']['telefone'] ?? '') ?>">
    </div>
    
    <div class="input-group">
        <span class="input-group-text">
            <i class="bi bi-building"></i>
        </span>
        <input type="text" class="form-control" name="departamento" placeholder="Departamento (opcional)" 
               value="<?= sanitize($_SESSION['form_data']['departamento'] ?? '') ?>">
    </div>
    
    <div class="input-group">
        <span class="input-group-text">
            <i class="bi bi-shield-check"></i>
        </span>
        <select class="form-select" name="tipo" required>
            <option value="">Selecione o tipo de usuário</option>
            <option value="recrutador" <?= ($_SESSION['form_data']['tipo'] ?? '') === 'recrutador' ? 'selected' : '' ?>>Recrutador</option>
            <option value="rh" <?= ($_SESSION['form_data']['tipo'] ?? '') === 'rh' ? 'selected' : '' ?>>RH</option>
        </select>
    </div>
    
    <div class="input-group">
        <span class="input-group-text">
            <i class="bi bi-lock"></i>
        </span>
        <input type="password" class="form-control" name="senha" id="senha" placeholder="Senha" required>
        <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('senha')">
            <i class="bi bi-eye"></i>
        </button>
    </div>
    
    <div class="input-group">
        <span class="input-group-text">
            <i class="bi bi-lock-fill"></i>
        </span>
        <input type="password" class="form-control" name="senha_confirmacao" id="senha_confirmacao" 
               placeholder="Confirme a senha" required>
        <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('senha_confirmacao')">
            <i class="bi bi-eye"></i>
        </button>
    </div>
    
    <div class="d-grid">
        <button type="submit" class="btn btn-primary">
            <i class="bi bi-person-plus me-2"></i>
            Criar Conta
        </button>
    </div>
</form>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('form');
    const senha = document.getElementById('senha');
    const senhaConfirmacao = document.getElementById('senha_confirmacao');
    
    function validatePasswords() {
        if (senha.value !== senhaConfirmacao.value) {
            senhaConfirmacao.setCustomValidity('As senhas não conferem');
            senhaConfirmacao.classList.add('is-invalid');
        } else {
            senhaConfirmacao.setCustomValidity('');
            senhaConfirmacao.classList.remove('is-invalid');
        }
    }
    
    senha.addEventListener('input', validatePasswords);
    senhaConfirmacao.addEventListener('input', validatePasswords);
    
    form.addEventListener('submit', function(e) {
        validatePasswords();
        
        if (senha.value.length < <?= PASSWORD_MIN_LENGTH ?>) {
            senha.setCustomValidity('A senha deve ter pelo menos <?= PASSWORD_MIN_LENGTH ?> caracteres');
            senha.classList.add('is-invalid');
            e.preventDefault();
            return false;
        }
        
        if (!validateForm(form)) {
            e.preventDefault();
            return false;
        }
    });
});
</script>

<?php
$content = ob_get_clean();
unset($_SESSION['form_data']);
require VIEWS_PATH . '/layouts/auth.php';
?>
