
<?php
$subtitle = 'Faça login para acessar o sistema';
$footer = '<p class="mb-0">Não tem conta? <a href="/register">Registre-se aqui</a></p>';

ob_start();
?>

<form method="POST" action="/login" novalidate>
    <input type="hidden" name="csrf_token" value="<?= generateCsrfToken() ?>">
    
    <div class="input-group">
        <span class="input-group-text">
            <i class="bi bi-envelope"></i>
        </span>
        <input type="email" class="form-control" name="email" placeholder="Seu email" required 
               value="<?= sanitize($_SESSION['form_data']['email'] ?? '') ?>">
    </div>
    
    <div class="input-group">
        <span class="input-group-text">
            <i class="bi bi-lock"></i>
        </span>
        <input type="password" class="form-control" name="password" id="password" placeholder="Sua senha" required>
        <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('password')">
            <i class="bi bi-eye"></i>
        </button>
    </div>
    
    <div class="form-check">
        <input class="form-check-input" type="checkbox" id="remember" name="remember" value="1">
        <label class="form-check-label" for="remember">
            Lembrar-me
        </label>
    </div>
    
    <div class="d-grid">
        <button type="submit" class="btn btn-primary">
            <i class="bi bi-box-arrow-in-right me-2"></i>
            Entrar
        </button>
    </div>
</form>

<?php
$content = ob_get_clean();
unset($_SESSION['form_data']);
require VIEWS_PATH . '/layouts/auth.php';
?>
