
# 🐳 Deploy na Infraestrutura RcTecNet - Gerenciador de Currículos

Este guia detalha como fazer o deploy do sistema na infraestrutura RcTecNet usando Portainer com Traefik.

## 📋 Configuração da Infraestrutura RcTecNet

### Especificações da Infraestrutura

**Domínios Configurados:**
- 🌐 **Aplicação Principal**: `rh.rivadavia.com.br`
- 🛠️ **phpMyAdmin**: `rhsql.rivadavia.com.br`

**Banco de Dados Externo:**
- 🗄️ **Host**: 209.126.87.237
- 📊 **Database**: rivadavi_ger_curriculos
- 👤 **User**: rivadavi_ger_curriculos
- 🔐 **Password**: Fji&*uwF6UTz6sZ6

**Infraestrutura Docker:**
- 🌐 **Network**: RcTecNet (externa)
- 📁 **Volume**: /var/lib/docker/volumes/gerenciador_curriculos_app/_data

### Pré-requisitos Específicos

- ✅ Servidor com Portainer instalado
- ✅ Traefik configurado na rede RcTecNet
- ✅ Rede RcTecNet criada no Docker
- ✅ Banco MySQL externo acessível (209.126.87.237)
- ✅ Domínios configurados no DNS

## 🚀 Processo de Deploy

### 1. Verificar a Rede RcTecNet

Antes do deploy, certifique-se que a rede existe:

```bash
# Verificar se a rede RcTecNet existe
docker network ls | grep RcTecNet

# Criar a rede se não existir
docker network create RcTecNet
```

### 2. Preparar o Stack no Portainer

1. **Acesse o Portainer da sua infraestrutura**

2. **Navegue para Stacks → Add Stack**

3. **Nome do Stack:** `gerenciador-curriculos`

### 3. Configuração Docker Compose para RcTecNet

Cole o seguinte docker-compose.yml configurado especificamente para RcTecNet:

```yaml
version: '3.8'

services:
  app:
    build:
      context: .
      dockerfile: Dockerfile
    container_name: gerenciador_curriculos_app
    restart: unless-stopped
    volumes:
      - /var/lib/docker/volumes/gerenciador_curriculos_app/_data:/var/www/html
      - ./public/uploads:/var/www/html/public/uploads
      - ./logs:/var/www/html/logs
      - app_sessions:/tmp
    environment:
      - APP_NAME=Gerenciador de Currículos
      - APP_URL=https://rh.rivadavia.com.br
      - APP_DEBUG=false
      - DB_HOST=209.126.87.237
      - DB_NAME=rivadavi_ger_curriculos
      - DB_USER=rivadavi_ger_curriculos
      - DB_PASS=Fji&*uwF6UTz6sZ6
      - SESSION_TIMEOUT=3600
      - PASSWORD_MIN_LENGTH=6
    networks:
      - RcTecNet
    labels:
      # Labels para Traefik - Aplicação Principal
      - "traefik.enable=true"
      - "traefik.http.routers.curriculos.rule=Host(`rh.rivadavia.com.br`)"
      - "traefik.http.routers.curriculos.entrypoints=websecure"
      - "traefik.http.services.curriculos.loadbalancer.server.port=80"
      - "traefik.docker.network=RcTecNet"
      - "traefik.http.routers.curriculos.tls.certresolver=letsencrypt"
      
      # Redirecionamento HTTP para HTTPS
      - "traefik.http.routers.curriculos-http.rule=Host(`rh.rivadavia.com.br`)"
      - "traefik.http.routers.curriculos-http.entrypoints=web"
      - "traefik.http.routers.curriculos-http.middlewares=curriculos-redirect"
      - "traefik.http.middlewares.curriculos-redirect.redirectscheme.scheme=https"

  # phpMyAdmin para administração do banco externo
  phpmyadmin:
    image: phpmyadmin:5.2-apache
    container_name: gerenciador_curriculos_phpmyadmin
    restart: unless-stopped
    environment:
      PMA_HOST: 209.126.87.237
      PMA_PORT: 3306
      PMA_USER: rivadavi_ger_curriculos
      PMA_PASSWORD: Fji&*uwF6UTz6sZ6
      MYSQL_ROOT_PASSWORD: Fji&*uwF6UTz6sZ6
      PMA_ARBITRARY: 1
    networks:
      - RcTecNet
    labels:
      # Labels para Traefik - phpMyAdmin
      - "traefik.enable=true"
      - "traefik.http.routers.phpmyadmin.rule=Host(`rhsql.rivadavia.com.br`)"
      - "traefik.http.routers.phpmyadmin.entrypoints=websecure"
      - "traefik.http.services.phpmyadmin.loadbalancer.server.port=80"
      - "traefik.docker.network=RcTecNet"
      - "traefik.http.routers.phpmyadmin.tls.certresolver=letsencrypt"
      
      # Redirecionamento HTTP para HTTPS
      - "traefik.http.routers.phpmyadmin-http.rule=Host(`rhsql.rivadavia.com.br`)"
      - "traefik.http.routers.phpmyadmin-http.entrypoints=web"
      - "traefik.http.routers.phpmyadmin-http.middlewares=phpmyadmin-redirect"
      - "traefik.http.middlewares.phpmyadmin-redirect.redirectscheme.scheme=https"

networks:
  RcTecNet:
    external: true

volumes:
  app_sessions:
    driver: local
```

### 4. Configurar Variáveis de Ambiente

**⚠️ IMPORTANTE:** As credenciais do banco já estão configuradas no docker-compose.yml para a infraestrutura RcTecNet.

**Não são necessárias variáveis de ambiente adicionais no Portainer**, pois todas as configurações específicas já estão no arquivo .env e no docker-compose.yml:

- **Banco de dados externo:** 209.126.87.237
- **Credenciais específicas** da infraestrutura RcTecNet
- **Domínios configurados:** rh.rivadavia.com.br e rhsql.rivadavia.com.br
- **Rede externa:** RcTecNet

### 4. Deploy

1. **Clique em "Deploy the stack"**
2. **Aguarde a inicialização** (pode levar alguns minutos)
3. **Verifique os logs** em caso de erro

## 🔧 Configurações Adicionais

### Traefik (se não configurado)

Certifique-se que seu `traefik.yml` inclui:

```yaml
entryPoints:
  web:
    address: ":80"
  websecure:
    address: ":443"

certificatesResolvers:
  letsencrypt:
    acme:
      email: seu-email@dominio.com
      storage: acme.json
      httpChallenge:
        entryPoint: web

providers:
  docker:
    exposedByDefault: false
```

### Backup Automático para Banco Externo

**⚠️ IMPORTANTE:** O backup deve ser configurado no servidor do banco (209.126.87.237).

Para backup do container da aplicação, adicione ao cron:

```bash
# Backup dos arquivos da aplicação às 2h da manhã
0 2 * * * rsync -av /var/lib/docker/volumes/gerenciador_curriculos_app/_data/ /backup/app_$(date +\%Y\%m\%d)/

# Backup do banco via conexão externa (se tiver acesso)
0 3 * * * mysqldump -h 209.126.87.237 -u rivadavi_ger_curriculos -p'Fji&*uwF6UTz6sZ6' rivadavi_ger_curriculos > /backup/db_$(date +\%Y\%m\%d).sql
```

### Monitoramento

Para monitorar o sistema, adicione estas labels ao serviço `app`:

```yaml
labels:
  # Prometheus monitoring
  - "prometheus.enable=true"
  - "prometheus.path=/metrics"
  - "prometheus.port=80"
```

## 📊 Acesso ao Sistema RcTecNet

### URLs de Acesso da Infraestrutura

- 🌐 **Aplicação Principal:** https://rh.rivadavia.com.br
- 🛠️ **phpMyAdmin:** https://rhsql.rivadavia.com.br

### Primeira Configuração

**⚠️ IMPORTANTE:** Na primeira execução, você precisará:

1. **Acessar:** https://rh.rivadavia.com.br
2. **Criar o primeiro usuário administrador** através do sistema de registro
3. **Configurar o sistema** conforme suas necessidades

### Acesso ao Banco de Dados

**phpMyAdmin (rhsql.rivadavia.com.br):**
- **Host:** 209.126.87.237
- **User:** rivadavi_ger_curriculos
- **Password:** Fji&*uwF6UTz6sZ6
- **Database:** rivadavi_ger_curriculos

## 🔍 Troubleshooting

### Verificar Status dos Containers RcTecNet

```bash
# Verificar containers da aplicação
docker ps -a | grep curriculos

# Verificar se estão na rede RcTecNet
docker network inspect RcTecNet
```

### Ver Logs

```bash
# Logs da aplicação
docker logs gerenciador_curriculos_app

# Logs do phpMyAdmin
docker logs gerenciador_curriculos_phpmyadmin

# Logs do Traefik (se necessário)
docker logs traefik
```

### Problemas Comuns na Infraestrutura RcTecNet

#### 1. Erro de Conexão com Banco Externo

**Sintoma:** Aplicação não conecta com MySQL externo (209.126.87.237)

**Verificações:**
```bash
# Testar conectividade de rede
ping 209.126.87.237

# Testar porta MySQL
telnet 209.126.87.237 3306

# Testar conexão MySQL diretamente
mysql -h 209.126.87.237 -u rivadavi_ger_curriculos -p'Fji&*uwF6UTz6sZ6' rivadavi_ger_curriculos

# Verificar logs da aplicação
docker logs gerenciador_curriculos_app
```

**Possíveis Causas:**
- Firewall bloqueando porta 3306
- Credenciais incorretas
- Banco inacessível
- Problemas de DNS/rede

#### 2. SSL não funciona

**Sintoma:** Certificado SSL não é gerado

**Verificações:**
- ✅ Domínio aponta para o servidor
- ✅ Portas 80 e 443 estão abertas
- ✅ Traefik está configurado corretamente
- ✅ Labels do Traefik estão corretas

#### 3. Upload de arquivos falha

**Sintoma:** Erro ao fazer upload de arquivos

**Solução:**
```bash
# Verificar permissões do diretório
docker exec gerenciador_curriculos_app ls -la /var/www/html/public/uploads

# Ajustar permissões se necessário
docker exec gerenciador_curriculos_app chown -R www-data:www-data /var/www/html/public/uploads
```

## 📈 Otimizações de Produção

### 1. Configurar PHP-FPM

Para melhor performance, considere usar PHP-FPM:

```dockerfile
FROM php:8.2-fpm-alpine
# ... configurações
```

### 2. Cache Redis

Adicione Redis para cache de sessões:

```yaml
redis:
  image: redis:7-alpine
  container_name: gerenciador_curriculos_redis
  restart: unless-stopped
  networks:
    - curriculos_network
```

### 3. Backup Automatizado

Configure backup automático no Portainer:

```yaml
backup:
  image: mysql:8.0
  container_name: curriculos_backup
  restart: "no"
  depends_on:
    - mysql
  volumes:
    - backup_data:/backup
    - ./scripts/backup.sh:/backup.sh
  command: /backup.sh
  networks:
    - curriculos_network
```

## 🛡️ Segurança

### Recomendações de Segurança

1. **Senhas Fortes:** Use senhas complexas para MySQL
2. **Firewall:** Configure firewall adequadamente
3. **Updates:** Mantenha imagens atualizadas
4. **Backup:** Configure backup regular
5. **Monitoramento:** Implemente monitoramento de logs

### Hardening do Container

```yaml
security_opt:
  - no-new-privileges:true
read_only: true
tmpfs:
  - /tmp
  - /var/tmp
cap_drop:
  - ALL
cap_add:
  - DAC_OVERRIDE
  - SETGID
  - SETUID
```

## 📞 Suporte

Para suporte técnico:

- 📧 **Email:** suporte@seudominio.com
- 💬 **Issues:** GitHub Issues
- 📖 **Docs:** Wiki do projeto

---

**Desenvolvido com ❤️ para facilitar o deploy no Portainer**
