
# 📋 Gerenciador de Currículos

Sistema completo de gerenciamento de currículos desenvolvido em PHP com MySQL, incluindo configurações Docker para deploy com Portainer/Traefik.

## ✨ Características

### 🚀 Funcionalidades Principais
- **Sistema de autenticação completo** com diferentes níveis de usuário
- **Gerenciamento de currículos** com dados pessoais, experiências, formação e habilidades
- **Upload seguro de arquivos** (PDF, DOC, DOCX)
- **Sistema de grupos e etiquetas** para organização
- **Busca avançada** com filtros múltiplos
- **Dashboard interativo** com gráficos e estatísticas
- **Sistema de relatórios** e exportação de dados
- **Interface responsiva** e moderna

### 👥 Níveis de Usuário
- **Administrador**: Acesso completo ao sistema
- **RH**: Gerenciamento de usuários e relatórios avançados
- **Recrutador**: Gerenciamento de currículos e grupos

### 🛠️ Tecnologias
- **Backend**: PHP 8.2 (OOP, MVC)
- **Banco de Dados**: MySQL 8.0
- **Frontend**: Bootstrap 5.3, Chart.js
- **Containerização**: Docker & Docker Compose
- **Servidor Web**: Apache
- **Orquestração**: Portainer + Traefik

## 📁 Estrutura do Projeto

```
gerenciador_curriculos/
├── 🐳 docker/                     # Configurações Docker
│   ├── apache/                   # Configurações do Apache
│   └── php/                      # Configurações PHP
├── 📂 public/                     # Arquivos públicos
│   ├── css/                      # Estilos personalizados
│   ├── js/                       # Scripts JavaScript  
│   ├── uploads/                  # Arquivos enviados
│   └── index.php                 # Ponto de entrada
├── 🗂️ src/                       # Código fonte
│   ├── controllers/              # Controllers MVC
│   ├── models/                   # Modelos de dados
│   ├── views/                    # Templates/Views
│   ├── services/                 # Serviços (Auth, etc)
│   └── utils/                    # Utilitários (Router)
├── ⚙️ config/                     # Configurações
│   ├── config.php               # Configurações gerais
│   └── database.php             # Conexão do banco
├── 📊 scripts/                    # Scripts SQL
│   └── init.sql                 # Schema e dados iniciais
├── 🐳 Dockerfile                  # Imagem Docker
├── 🐳 docker-compose.yml          # Orquestração
├── ⚙️ .env.example               # Variáveis de ambiente
└── 📖 README.md                   # Documentação
```

## 🚀 Deploy na Infraestrutura RcTecNet

### 1️⃣ Pré-requisitos da Infraestrutura

- **Servidor com Portainer instalado**
- **Traefik configurado** na rede RcTecNet
- **Banco MySQL externo** configurado (209.126.87.237)
- **Rede RcTecNet** criada no Docker

### 2️⃣ Configuração da Infraestrutura RcTecNet

**Domínios configurados:**
- 🌐 **Aplicação Principal**: `rh.rivadavia.com.br`
- 🛠️ **phpMyAdmin**: `rhsql.rivadavia.com.br`

**Banco de Dados Externo:**
- 🗄️ **Host**: 209.126.87.237
- 📊 **Database**: rivadavi_ger_curriculos
- 👤 **User**: rivadavi_ger_curriculos
- 🔐 **Password**: Fji&*uwF6UTz6sZ6

**Rede Docker:**
- 🌐 **Network**: RcTecNet (externa)
- 📁 **Volume**: /var/lib/docker/volumes/gerenciador_curriculos_app/_data

### 3️⃣ Setup da Rede RcTecNet

Certifique-se que a rede RcTecNet existe no seu ambiente Docker:

```bash
# Criar a rede RcTecNet (se não existir)
docker network create RcTecNet

# Verificar se a rede existe
docker network ls | grep RcTecNet
```

### 4️⃣ Configuração no Portainer

#### Via Interface Web do Portainer

1. **Acesse o Portainer**

2. **Vá em "Stacks" → "Add Stack"**
   - **Nome do Stack**: `gerenciador-curriculos`

3. **Cole o conteúdo do docker-compose.yml** (já configurado com as especificações RcTecNet)

4. **Variáveis de Ambiente (já configuradas no .env):**
   ```env
   APP_URL=https://rh.rivadavia.com.br
   DB_HOST=209.126.87.237
   DB_NAME=rivadavi_ger_curriculos
   DB_USER=rivadavi_ger_curriculos
   DB_PASS=Fji&*uwF6UTz6sZ6
   ```

5. **Deploy o Stack**

### 5️⃣ Configuração dos Domínios Traefik

Os labels Traefik já estão configurados no docker-compose.yml:

**Para Aplicação Principal (rh.rivadavia.com.br):**
```yaml
labels:
  - "traefik.enable=true"
  - "traefik.http.routers.curriculos.rule=Host(`rh.rivadavia.com.br`)"
  - "traefik.http.routers.curriculos.entrypoints=websecure"
  - "traefik.http.routers.curriculos.tls.certresolver=letsencrypt"
  - "traefik.docker.network=RcTecNet"
```

**Para phpMyAdmin (rhsql.rivadavia.com.br):**
```yaml
labels:
  - "traefik.enable=true"
  - "traefik.http.routers.phpmyadmin.rule=Host(`rhsql.rivadavia.com.br`)"
  - "traefik.http.routers.phpmyadmin.entrypoints=websecure"
  - "traefik.http.routers.phpmyadmin.tls.certresolver=letsencrypt"
  - "traefik.docker.network=RcTecNet"
```

### 6️⃣ Verificação e Teste

1. **Acesse a aplicação:** 
   - 🌐 **App**: `https://rh.rivadavia.com.br`
   - 🛠️ **phpMyAdmin**: `https://rhsql.rivadavia.com.br`

2. **Teste de conexão com banco:**
   ```bash
   # Verificar logs do container
   docker logs gerenciador_curriculos_app
   ```

3. **Primeira configuração:**
   - Acesse: `https://rh.rivadavia.com.br`
   - Crie o primeiro usuário admin através do sistema

### 7️⃣ Configurações de Segurança Específicas

**SSL/HTTPS (Automático via Let's Encrypt):**
- ✅ Certificados automáticos via Traefik
- ✅ Redirecionamento HTTP → HTTPS configurado
- ✅ Headers de segurança habilitados

**Banco de Dados:**
- ✅ Conexão segura com MySQL externo
- ✅ Credenciais específicas da infraestrutura
- ✅ Backup deve ser feito no servidor 209.126.87.237

## 🔧 Configuração Local para Desenvolvimento

### Usando Docker

```bash
# Clone o repositório
git clone https://github.com/seu-usuario/gerenciador-curriculos.git
cd gerenciador-curriculos

# Configure o ambiente
cp .env.example .env

# Inicie os serviços
docker-compose up -d

# Acesse: http://localhost:8080
```

### Configuração Manual

#### Requisitos
- PHP 8.2+
- MySQL 8.0+
- Apache/Nginx
- Extensões: PDO, MySQL, GD, ZIP

#### Instalação
```bash
# Configure o banco
mysql -u root -p < scripts/init.sql

# Configure o servidor web
# Apache: Aponte DocumentRoot para /public/
# Nginx: Configure conforme necessário

# Configure permissões
chmod 755 public/uploads
chmod 755 logs
```

## 📊 Funcionalidades Detalhadas

### 👤 Sistema de Usuários
- Registro e login seguro
- Controle de sessão
- Diferentes níveis de acesso
- Perfil de usuário editável

### 📄 Gerenciamento de Currículos
- **Dados Pessoais**: Nome, contato, endereço
- **Experiências**: Histórico profissional completo
- **Formação**: Educação e cursos
- **Habilidades**: Técnicas e comportamentais
- **Idiomas**: Níveis de proficiência
- **Arquivos**: Upload de documentos

### 🏷️ Organização
- **Grupos**: Categorização por área/cargo
- **Etiquetas**: Tags personalizadas
- **Status**: Acompanhamento do processo seletivo
- **Pontuação**: Sistema de avaliação

### 📈 Relatórios
- Dashboard com métricas
- Gráficos interativos
- Exportação CSV
- Filtros avançados

## 🔒 Segurança

- Autenticação por sessão
- Proteção CSRF
- Hash seguro de senhas (bcrypt)
- Validação de uploads
- SQL Injection prevention (PDO)
- Headers de segurança

## 🌐 API Endpoints

### Autenticação
- `POST /login` - Fazer login
- `GET /logout` - Fazer logout
- `POST /register` - Registrar usuário

### Currículos
- `GET /curriculos` - Listar currículos
- `GET /curriculos/{id}` - Visualizar currículo
- `POST /curriculos` - Criar currículo
- `POST /curriculos/{id}` - Atualizar currículo
- `DELETE /curriculos/{id}` - Excluir currículo

### Upload
- `POST /upload` - Upload de arquivo
- `GET /files/{file}` - Servir arquivo

## 🐛 Troubleshooting

### Problemas Comuns

#### Erro de Conexão com Banco
```bash
# Verifique se o MySQL está rodando
docker-compose ps

# Verifique logs
docker-compose logs mysql
```

#### Erro de Permissão
```bash
# Ajuste permissões
sudo chown -R www-data:www-data public/uploads
sudo chmod -R 755 public/uploads
```

#### Erro 500
```bash
# Ative debug no .env
APP_DEBUG=true

# Verifique logs
docker-compose logs app
```

## 📝 Configurações Avançadas

### SSL/HTTPS
```yaml
# Para produção com SSL
labels:
  - "traefik.http.routers.curriculos-secure.tls=true"
  - "traefik.http.routers.curriculos-secure.tls.certresolver=letsencrypt"
```

### Backup Automático
```bash
# Adicione ao cron
0 2 * * * docker exec curriculos_mysql mysqldump -u root -pSUA_SENHA gerenciador_curriculos > /backup/curriculos_$(date +%Y%m%d).sql
```

### Monitoramento
- Logs: `/var/log/apache2/` (dentro do container)
- Métricas: Use Prometheus + Grafana
- Alertas: Configure via Traefik + AlertManager

## 🤝 Contribuição

1. Fork o projeto
2. Crie sua branch (`git checkout -b feature/nova-funcionalidade`)
3. Commit suas mudanças (`git commit -am 'Adiciona nova funcionalidade'`)
4. Push para a branch (`git push origin feature/nova-funcionalidade`)
5. Abra um Pull Request

## 📄 Licença

Este projeto está sob a licença MIT. Veja o arquivo `LICENSE` para detalhes.

## 🆘 Suporte

- 📧 Email: suporte@seudominio.com
- 💬 Issues: [GitHub Issues](https://github.com/seu-usuario/gerenciador-curriculos/issues)
- 📖 Wiki: [Documentação Completa](https://github.com/seu-usuario/gerenciador-curriculos/wiki)

---

**Desenvolvido com ❤️ para facilitar o gerenciamento de currículos**
