
# 🚀 Deploy Completo - Infraestrutura RcTecNet

## 📋 Resumo da Configuração

### Infraestrutura RcTecNet
- **🌐 Domínio App:** rh.rivadavia.com.br
- **🛠️ Domínio phpMyAdmin:** rhsql.rivadavia.com.br
- **🗄️ Banco MySQL Externo:** 209.126.87.237
- **📊 Database:** rivadavi_ger_curriculos
- **👤 User:** rivadavi_ger_curriculos
- **🔐 Password:** Fji&*uwF6UTz6sZ6
- **🌐 Rede Docker:** RcTecNet (externa)
- **📁 Volume:** /var/lib/docker/volumes/gerenciador_curriculos_app/_data

## 🔄 Checklist de Deploy

### ✅ Pré-requisitos
- [ ] Servidor com Portainer instalado e funcionando
- [ ] Traefik configurado na rede RcTecNet
- [ ] Rede Docker RcTecNet criada
- [ ] Banco MySQL externo acessível (209.126.87.237)
- [ ] DNS configurado para os domínios

### ✅ Verificações Iniciais

```bash
# 1. Verificar rede RcTecNet
docker network ls | grep RcTecNet

# Se não existir, criar:
docker network create RcTecNet

# 2. Testar conexão com banco externo
ping 209.126.87.237
telnet 209.126.87.237 3306

# 3. Testar credenciais do banco
mysql -h 209.126.87.237 -u rivadavi_ger_curriculos -p'Fji&*uwF6UTz6sZ6' rivadavi_ger_curriculos
```

### ✅ Configuração do Banco de Dados

**Importante:** Execute o script de inicialização no banco externo:

```bash
# Executar script no banco externo
mysql -h 209.126.87.237 -u rivadavi_ger_curriculos -p'Fji&*uwF6UTz6sZ6' rivadavi_ger_curriculos < scripts/init_rctecnet.sql
```

### ✅ Deploy no Portainer

1. **Acesse o Portainer**
2. **Stacks → Add Stack**
3. **Nome:** `gerenciador-curriculos`
4. **Cole o docker-compose.yml** (já configurado para RcTecNet)
5. **Deploy**

## 📄 Arquivos Configurados

### ✅ docker-compose.yml
```yaml
# Configurado com:
- Rede RcTecNet externa
- Banco de dados externo (209.126.87.237)
- Domínios rh.rivadavia.com.br e rhsql.rivadavia.com.br
- Volume específico da infraestrutura
- Labels Traefik com SSL automático
```

### ✅ .env
```env
# Configurado com:
- APP_URL=https://rh.rivadavia.com.br
- Credenciais do banco externo RcTecNet
- Configurações de produção (DEBUG=false)
- Domínios específicos da infraestrutura
```

### ✅ Scripts SQL
```sql
# init_rctecnet.sql configurado com:
- Database: rivadavi_ger_curriculos
- Tabelas otimizadas para produção
- Dados iniciais
- Configurações de performance
```

## 🔍 Verificações Pós-Deploy

### ✅ Status dos Containers
```bash
# Verificar containers
docker ps | grep curriculos

# Verificar logs
docker logs gerenciador_curriculos_app
docker logs gerenciador_curriculos_phpmyadmin
```

### ✅ Acesso aos Domínios
- **App Principal:** https://rh.rivadavia.com.br
- **phpMyAdmin:** https://rhsql.rivadavia.com.br

### ✅ Teste de Funcionalidades
1. Acesso ao sistema principal
2. Registro do primeiro usuário admin
3. Conexão com banco via phpMyAdmin
4. Upload de arquivos
5. Certificados SSL funcionando

## 🛠️ Configurações de Produção

### ✅ Segurança Configurada
- SSL automático via Let's Encrypt
- Redirecionamento HTTP → HTTPS
- Headers de segurança
- Credenciais seguras do banco

### ✅ Performance Otimizada
- Volume específico para dados persistentes
- Configurações MySQL otimizadas
- Logs estruturados
- Cache de sessões

### ✅ Backup Recomendado
```bash
# Backup de arquivos (cron)
0 2 * * * rsync -av /var/lib/docker/volumes/gerenciador_curriculos_app/_data/ /backup/app_$(date +\%Y\%m\%d)/

# Backup do banco (se tiver acesso)
0 3 * * * mysqldump -h 209.126.87.237 -u rivadavi_ger_curriculos -p'Fji&*uwF6UTz6sZ6' rivadavi_ger_curriculos > /backup/db_$(date +\%Y\%m\%d).sql
```

## 🚨 Troubleshooting Rápido

### Problema: Erro de Conexão com Banco
```bash
# Verificar conectividade
ping 209.126.87.237
telnet 209.126.87.237 3306

# Verificar logs
docker logs gerenciador_curriculos_app
```

### Problema: SSL não funciona
```bash
# Verificar Traefik
docker logs traefik

# Verificar rede
docker network inspect RcTecNet
```

### Problema: Upload não funciona
```bash
# Verificar permissões
docker exec gerenciador_curriculos_app ls -la /var/www/html/public/uploads
```

## 📞 Suporte

### Configuração Específica RcTecNet
- **Infraestrutura:** Configurada para rede RcTecNet
- **Banco Externo:** 209.126.87.237
- **Domínios:** rivadavia.com.br
- **SSL:** Let's Encrypt automático

### Arquivos de Configuração
- `docker-compose.yml` - Orquestração principal
- `.env` - Variáveis de ambiente
- `scripts/init_rctecnet.sql` - Inicialização do banco
- `deploy-portainer.md` - Guia detalhado
- `README.md` - Documentação completa

---

**✅ Sistema pronto para produção na infraestrutura RcTecNet!**

### Próximos Passos Após Deploy
1. Acesse https://rh.rivadavia.com.br
2. Crie o primeiro usuário administrador
3. Configure os grupos e etiquetas conforme necessário
4. Configure backup automático
5. Configure monitoramento (opcional)

**🔐 Lembre-se:** Todas as credenciais estão configuradas para a infraestrutura RcTecNet específica.
